# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish trust
    if current_round == 1:
        return "C"
    
    # Check if opponent is likely to defect in Round 10
    opponent_likely_defect_10 = ("current_round == 10" in opponent_program_code and "return 'D'" in opponent_program_code)
    
    # Rounds 2-7: Adaptive Tit-for-Tat with occasional forgiveness
    if 2 <= current_round <= 7:
        if opp_history[-1] == "D":
            # 20% chance to forgive
            if random.random() < 0.2:
                return "C"
            else:
                return "D"
        else:
            return "C"
    
    # Rounds 8-10: Late-game exploitation
    if current_round >= 8:
        if current_round == 10:
            return "D"
        elif current_round == 9 and opponent_likely_defect_10:
            return "D"
        else:
            if opp_history[-1] == "D":
                return "D"
            else:
                return "C"
    
    # Default fallback
    return "C"